<?php
function image($account_id, $ID, $battles, $avg_tier, $wn8, $rwn8, $win, $rwin, $tier, $mosaic)
{
    //画像の元を生成
    $img = imageCreateTrueColor(200, 80);

    //画像の背景色をセット
    $backColor = ImageColorAllocate($img, 0, 0, 0);
    ImageFilledRectangle($img, 0, 0, 200, 80, $backColor);

    //画像に文字をセット（白）
    $textColor = ImageColorAllocate($img, 255, 255, 255);
    imageString($img, 5, 10, 7, "ID:".$ID, $textColor);
    if($mosaic[0] == true)
    {
      imageString($img, 5, 10, 27, "BAT:".$battles."*", $textColor);
    }
    else
    {
      imageString($img, 5, 10, 27, "BAT:".$battles, $textColor);
    }

    if($mosaic[1] == true)
    {
    imageString($img, 5, 10, 42, "WN8:".$wn8."*", $textColor);
    }
    else
    {
    imageString($img, 5, 10, 42, "WN8:".$wn8, $textColor);
    }

    if($mosaic[2] == true)
    {
    imageString($img, 5, 10, 57, "WIN:".$win."*", $textColor);
    }
    else
    {
    imageString($img, 5, 10, 57, "WIN:".$win, $textColor);
    }

    //Tier
    $lineColor = ImageColorAllocate($img, 255, 255, 255);
    $mostBattlesTier = array_search(max($tier), $tier);
    $tierLineLength = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    for($n1 = 0; $n1 < 10; $n1++)
    {
      $tierLineLength[$n1] = (double)40 * ((double)$tier[$n1] / (double)$tier[$mostBattlesTier]);
    }
    for($n1 = 0; $n1 < 10; $n1++)
    {
     ImageFilledRectangle($img, 100 + 7 * $n1,70, 105 + 7 * $n1,70 - $tierLineLength[$n1], $lineColor);
    }

    //カラー
    $lineColor;
    if(0 <= $wn8 && $wn8 <= 299)
    {
     $lineColor = ImageColorAllocate($img, 147, 13, 13);
    }
    else if(300 <= $wn8 && $wn8 <= 499)
    {
     $lineColor = ImageColorAllocate($img, 205, 51, 51);
    }
    else if(450 <= $wn8 && $wn8 <= 649)
    {
     $lineColor = ImageColorAllocate($img, 204, 122, 0);
    }
    else if(650 <= $wn8 && $wn8 <= 899)
    {
     $lineColor = ImageColorAllocate($img, 204, 184, 3);
    }
    else if(900 <= $wn8 && $wn8 <= 1199)
    {
     $lineColor = ImageColorAllocate($img, 132, 155, 36);
    }
    else if(1200 <= $wn8 && $wn8 <= 1599)
    {
     $lineColor = ImageColorAllocate($img, 77, 115, 38);
    }
    else if(1600 <= $wn8 && $wn8 <= 1999)
    {
     $lineColor = ImageColorAllocate($img, 64, 153, 192);
    }
    else if(2000 <= $wn8 && $wn8 <= 2449)
    {
     $lineColor = ImageColorAllocate($img, 57, 114, 198);
    }
    else if(2450 <= $wn8 && $wn8 <= 2899)
    {
     $lineColor = ImageColorAllocate($img, 121, 61, 182);
    }
    else if(2900 <= $wn8 )
    {
     $lineColor = ImageColorAllocate($img, 64, 16, 112);
    }
    ImageFilledRectangle($img, 180,0, 200,80, $lineColor);

    $account_id_hash = md5(date("YmdH") + $account_id);
    $path = "./images/".$account_id_hash.".png";
    $fullpath = "http://iunicam.main.jp/images/".$account_id_hash.".png";

    //作成
    imagepng($img, "$path");
    imagedestroy($img);
    return $fullpath;
}
  ?>
